import { operate, from, Observable } from '../Observable.js';
export function exhaustMap(project) {
    return (source) => new Observable((destination) => {
        let index = 0;
        let innerSub = null;
        let isComplete = false;
        source.subscribe(operate({
            destination,
            next: (outerValue) => {
                if (!innerSub) {
                    innerSub = operate({
                        destination,
                        complete: () => {
                            innerSub = null;
                            isComplete && destination.complete();
                        },
                    });
                    from(project(outerValue, index++)).subscribe(innerSub);
                }
            },
            complete: () => {
                isComplete = true;
                !innerSub && destination.complete();
            },
        }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/56f0a83df8e9eb48585fcc4858a9440db4cc7770/node_modules/rxjs/dist/esm/internal/operators/exhaustMap.js.map