"use strict";
/*
 * Copyright The OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DEFAULT_QUERY_STRINGS_TO_REDACT = exports.STR_REDACTED = exports.SYNTHETIC_BOT_NAMES = exports.SYNTHETIC_TEST_NAMES = void 0;
/**
 * Names of possible synthetic test sources.
 */
exports.SYNTHETIC_TEST_NAMES = ['alwayson'];
/**
 * Names of possible synthetic bot sources.
 */
exports.SYNTHETIC_BOT_NAMES = ['googlebot', 'bingbot'];
/**
 * REDACTED string used to replace sensitive information in URLs.
 */
exports.STR_REDACTED = 'REDACTED';
/**
 * List of URL query keys that are considered sensitive and whose value should be redacted.
 */
exports.DEFAULT_QUERY_STRINGS_TO_REDACT = [
    'sig',
    'Signature',
    'AWSAccessKeyId',
    'X-Goog-Signature',
];//# sourceMappingURL=http://go/sourcemap/sourcemaps/56f0a83df8e9eb48585fcc4858a9440db4cc7770/node_modules/@opentelemetry/instrumentation-http/build/src/internal-types.js.map