# -*- coding: utf-8 -*-
from setuphelpers import *


def install():

    bin_name = glob.glob("CursorSetup-x64-*.exe")[0]

    # Uninstalling older version of the software that can remains
    for to_uninstall in installed_softwares(name="Cursor"):
      if Version(to_uninstall["version"]) < Version(control.get_software_version()):
        print(f"Removing: {to_uninstall['name']} ({to_uninstall['version']})")
        killalltasks(ensure_list(control.impacted_process))
        run(uninstall_cmd(to_uninstall["key"]))
        wait_uninstallkey_absent(to_uninstall["key"])

    install_exe_if_needed(
        bin_name,
        silentflags="/VERYSILENT",
        name="Cursor",
        min_version=control.get_software_version(),
    )