import { Observable, operate } from '../Observable.js';
export function every(predicate, thisArg) {
    return (source) => new Observable((destination) => {
        let index = 0;
        source.subscribe(operate({
            destination,
            next: (value) => {
                if (!predicate.call(thisArg, value, index++, source)) {
                    destination.next(false);
                    destination.complete();
                }
            },
            complete: () => {
                destination.next(true);
                destination.complete();
            },
        }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/ce371ffbf5e240ca47f4b5f3f20efed084991120/node_modules/rxjs/dist/esm/internal/operators/every.js.map