"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.materialize = void 0;
const Observable_js_1 = require("../Observable.js");
function materialize() {
    return (source) => new Observable_js_1.Observable((destination) => {
        source.subscribe((0, Observable_js_1.operate)({
            destination,
            next: (value) => {
                destination.next((0, Observable_js_1.nextNotification)(value));
            },
            error: (error) => {
                destination.next((0, Observable_js_1.errorNotification)(error));
                destination.complete();
            },
            complete: () => {
                destination.next(Observable_js_1.COMPLETE_NOTIFICATION);
                destination.complete();
            },
        }));
    });
}
exports.materialize = materialize;//# sourceMappingURL=http://go/sourcemap/sourcemaps/ce371ffbf5e240ca47f4b5f3f20efed084991120/node_modules/rxjs/dist/cjs/internal/operators/materialize.js.map