import { Observable, operate } from '../Observable.js';
export function defaultIfEmpty(defaultValue) {
    return (source) => new Observable((destination) => {
        let hasValue = false;
        source.subscribe(operate({
            destination,
            next: (value) => {
                hasValue = true;
                destination.next(value);
            },
            complete: () => {
                if (!hasValue) {
                    destination.next(defaultValue);
                }
                destination.complete();
            },
        }));
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/ce371ffbf5e240ca47f4b5f3f20efed084991120/node_modules/rxjs/dist/esm/internal/operators/defaultIfEmpty.js.map