import { Observable, operate, from } from '../Observable.js';
export function catchError(selector) {
    return (source) => new Observable((destination) => {
        let innerSub = null;
        let syncUnsub = false;
        let handledResult;
        innerSub = source.subscribe(operate({
            destination,
            error: (err) => {
                handledResult = from(selector(err, catchError(selector)(source)));
                if (innerSub) {
                    innerSub.unsubscribe();
                    innerSub = null;
                    handledResult.subscribe(destination);
                }
                else {
                    syncUnsub = true;
                }
            },
        }));
        if (syncUnsub) {
            innerSub.unsubscribe();
            innerSub = null;
            handledResult.subscribe(destination);
        }
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/ce371ffbf5e240ca47f4b5f3f20efed084991120/node_modules/rxjs/dist/esm/internal/operators/catchError.js.map