import { Observable, operate, from } from '../Observable.js';
import { noop } from '../util/noop.js';
export function buffer(closingNotifier) {
    return (source) => new Observable((destination) => {
        let currentBuffer = [];
        from(closingNotifier).subscribe(operate({
            destination,
            next: () => {
                const b = currentBuffer;
                currentBuffer = [];
                destination.next(b);
            },
            complete: noop,
        }));
        source.subscribe(operate({
            destination,
            next: (value) => currentBuffer.push(value),
            complete: () => {
                destination.next(currentBuffer);
                destination.complete();
            },
        }));
        return () => {
            currentBuffer = null;
        };
    });
}//# sourceMappingURL=http://go/sourcemap/sourcemaps/ce371ffbf5e240ca47f4b5f3f20efed084991120/node_modules/rxjs/dist/esm/internal/operators/buffer.js.map