"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.switchMap = void 0;
const Observable_js_1 = require("../Observable.js");
function switchMap(project) {
    return (source) => new Observable_js_1.Observable((destination) => {
        let innerSubscriber = null;
        let index = 0;
        let isComplete = false;
        const checkComplete = () => isComplete && !innerSubscriber && destination.complete();
        source.subscribe((0, Observable_js_1.operate)({
            destination,
            next: (value) => {
                innerSubscriber?.unsubscribe();
                const outerIndex = index++;
                (0, Observable_js_1.from)(project(value, outerIndex)).subscribe((innerSubscriber = (0, Observable_js_1.operate)({
                    destination,
                    complete: () => {
                        innerSubscriber = null;
                        checkComplete();
                    },
                })));
            },
            complete: () => {
                isComplete = true;
                checkComplete();
            },
        }));
    });
}
exports.switchMap = switchMap;//# sourceMappingURL=http://go/sourcemap/sourcemaps/ce371ffbf5e240ca47f4b5f3f20efed084991120/node_modules/rxjs/dist/cjs/internal/operators/switchMap.js.map