import { defineIntegration } from '@sentry/core';
import { startSession, endSessionOnExit } from '../sessions.js';

/** Tracks sessions as the main process lifetime. */
const mainProcessSessionIntegration = defineIntegration((options = {}) => {
    return {
        name: 'MainProcessSession',
        setup() {
            startSession(!!options.sendOnCreate);
            endSessionOnExit();
        },
    };
});

export { mainProcessSessionIntegration };//# sourceMappingURL=http://go/sourcemap/sourcemaps/ce371ffbf5e240ca47f4b5f3f20efed084991120/node_modules/@sentry/electron/esm/main/integrations/main-process-session.js.map
