"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buffer = void 0;
const Observable_js_1 = require("../Observable.js");
const noop_js_1 = require("../util/noop.js");
function buffer(closingNotifier) {
    return (source) => new Observable_js_1.Observable((destination) => {
        let currentBuffer = [];
        (0, Observable_js_1.from)(closingNotifier).subscribe((0, Observable_js_1.operate)({
            destination,
            next: () => {
                const b = currentBuffer;
                currentBuffer = [];
                destination.next(b);
            },
            complete: noop_js_1.noop,
        }));
        source.subscribe((0, Observable_js_1.operate)({
            destination,
            next: (value) => currentBuffer.push(value),
            complete: () => {
                destination.next(currentBuffer);
                destination.complete();
            },
        }));
        return () => {
            currentBuffer = null;
        };
    });
}
exports.buffer = buffer;//# sourceMappingURL=http://go/sourcemap/sourcemaps/2d3ce3499c15efd55b6b8538ea255eb7ba4266b0/node_modules/rxjs/dist/cjs/internal/operators/buffer.js.map