Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const constants = require('./constants.js');

/**
 * Check if a method path should be instrumented
 */
function shouldInstrument(methodPath) {
  // Check for exact matches first (like 'models.generateContent')
  if (constants.GOOGLE_GENAI_INSTRUMENTED_METHODS.includes(methodPath )) {
    return true;
  }

  // Check for method name matches (like 'sendMessage' from chat instances)
  const methodName = methodPath.split('.').pop();
  return constants.GOOGLE_GENAI_INSTRUMENTED_METHODS.includes(methodName );
}

/**
 * Check if a method is a streaming method
 */
function isStreamingMethod(methodPath) {
  return (
    methodPath.includes('Stream') ||
    methodPath.endsWith('generateContentStream') ||
    methodPath.endsWith('sendMessageStream')
  );
}

exports.isStreamingMethod = isStreamingMethod;
exports.shouldInstrument = shouldInstrument;//# sourceMappingURL=http://go/sourcemap/sourcemaps/f6a8593b2b7c61c2063c79d5a8fcd248c9db4580/node_modules/@sentry/core/build/cjs/utils/google-genai/utils.js.map
