import { defineIntegration, normalize } from '@sentry/core';
import { addScopeListener } from '../../common/scope.js';
import { getIPC } from '../ipc.js';

/**
 * Passes scope changes to the main process.
 */
const scopeToMainIntegration = defineIntegration(() => {
    return {
        name: 'ScopeToMain',
        setup() {
            const ipc = getIPC();
            addScopeListener((merged, changed) => {
                ipc.sendScope(JSON.stringify(normalize(merged, 20, 2000)));
                changed.clearBreadcrumbs();
                changed.clearAttachments();
            });
        },
    };
});

export { scopeToMainIntegration };//# sourceMappingURL=http://go/sourcemap/sourcemaps/9e7a27b76730ca7fe4aecaeafc58bac1e2c82120/node_modules/@sentry/electron/esm/renderer/integrations/scope-to-main.js.map
