# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name

    os_dict = {
        'windows-x64': 'win32-x64',
        'windows-arm64': 'win32-arm64',
        'darwin-arm': 'darwin-arm64',
        'darwin-x64': 'darwin-x64',
        'linux-x64': 'linux-x64',
        'linux-arm64': 'linux-arm64',
    }

    os_type = control.target_os + "-" + ensure_list(control.architecture)[0]
    latest_version_api = f"https://api2.cursor.sh/updates/api/update/{os_dict[os_type]}/cursor/1.6.46/d98ca2ac6e4858851d5ea1c327187dbd1d8aeed3550bd8d4c73fffbaffb21a4b/stable"
    user_agent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Cursor/1.7.43 Chrome/132.0.6834.210 Electron/34.5.8 Safari/537.36"

    json_latest_version = wgets(latest_version_api, proxies=proxies, user_agent=user_agent, as_json=True)
    version, download_url = json_latest_version['name'], json_latest_version['url']
    latest_bin = download_url.rsplit('/', 1)[-1]
    latest_bin_extension = latest_bin.rsplit('.', 1)[-1]

    # Downloading latest binaries
    print(f"Latest {app_name} version is: {version}")
    print(f"Download URL is: {download_url}")
    if not isfile(latest_bin):
        print(f"Downloading: {latest_bin}")
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print(f"Binary is present: {latest_bin}")

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print(f"Software version updated (from: {control.get_software_version()} to: {Version(version)})")
        package_updated = True
    else:
        print(f"Software version up-to-date ({Version(version)})")

    for f in glob.glob(f'*.{latest_bin_extension}'):
        if f != latest_bin:
            remove_file(f)

    control.set_software_version(version)
    control.save_control_to_wapt()

    return package_updated