const core = require('@sentry/core');
const ipc = require('../ipc.js');

const eventLoopBlockIntegration = core.defineIntegration((options) => {
    const anrThreshold = options?.threshold ?? 1000;
    const pollInterval = options?.pollInterval || anrThreshold / 2;
    return {
        name: 'EventLoopBlockRenderer',
        setup() {
            const config = {
                pollInterval,
                anrThreshold,
                captureStackTrace: true,
                ...options,
            };
            const ipc$1 = ipc.getIPC();
            // eslint-disable-next-line no-restricted-globals
            ipc$1.sendStatus({ status: document.visibilityState, config });
            setInterval(() => {
                ipc$1.sendStatus({ status: 'alive', config });
            }, config.pollInterval);
        },
    };
});

exports.eventLoopBlockIntegration = eventLoopBlockIntegration;//# sourceMappingURL=http://go/sourcemap/sourcemaps/9e7a27b76730ca7fe4aecaeafc58bac1e2c82120/node_modules/@sentry/electron/renderer/integrations/event-loop-block.js.map
