let cachedDebuggerEnabled;

/**
 * Was the debugger enabled when this function was first called?
 */
async function isDebuggerEnabled() {
  if (cachedDebuggerEnabled === undefined) {
    try {
      // Node can be built without inspector support
      const inspector = await import('node:inspector');
      cachedDebuggerEnabled = !!inspector.url();
    } catch {
      cachedDebuggerEnabled = false;
    }
  }

  return cachedDebuggerEnabled;
}

export { isDebuggerEnabled };//# sourceMappingURL=http://go/sourcemap/sourcemaps/ab6b80c19b51fe71d58e69d8ed3802be587b3410/node_modules/@sentry/node-core/build/esm/utils/debug.js.map
