Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

/**
 * Converts a string-based level into a `SeverityLevel`, normalizing it along the way.
 *
 * @param level String representation of desired `SeverityLevel`.
 * @returns The `SeverityLevel` corresponding to the given string, or 'log' if the string isn't a valid level.
 */
function severityLevelFromString(level) {
  return (
    level === 'warn' ? 'warning' : ['fatal', 'error', 'warning', 'log', 'info', 'debug'].includes(level) ? level : 'log'
  ) ;
}

exports.severityLevelFromString = severityLevelFromString;//# sourceMappingURL=http://go/sourcemap/sourcemaps/ab6b80c19b51fe71d58e69d8ed3802be587b3410/node_modules/@sentry/core/build/cjs/utils/severity.js.map
