const core = require('@sentry/core');
const scope = require('../../common/scope.js');
const ipc = require('../ipc.js');

/**
 * Passes scope changes to the main process.
 */
const scopeToMainIntegration = core.defineIntegration(() => {
    return {
        name: 'ScopeToMain',
        setup() {
            const ipc$1 = ipc.getIPC();
            scope.addScopeListener((merged, changed) => {
                ipc$1.sendScope(JSON.stringify(core.normalize(merged, 20, 2000)));
                changed.clearBreadcrumbs();
                changed.clearAttachments();
            });
        },
    };
});

exports.scopeToMainIntegration = scopeToMainIntegration;//# sourceMappingURL=http://go/sourcemap/sourcemaps/ab6b80c19b51fe71d58e69d8ed3802be587b3410/node_modules/@sentry/electron/renderer/integrations/scope-to-main.js.map
