# -*- coding: utf-8 -*-
##################################################
# This file is part of WAPT Enterprise
# All right reserved, (c) Tranquil IT Systems 2023
# For more information please refer to
# https://wapt.tranquil.it/store/licences.html
##################################################
from setuphelpers import *


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name

    api_url = "https://api.github.com/repos/cryptomator/cryptomator/releases/latest"
    
    update_dict = {
        "windows-x64" : ".msi",
        "darwin-x64" : "x64.dmg",
        "darwin-arm" : "arm64.dmg",
        "linux-x64" : "x86_64.AppImage",
        "linux-arm64" : "aarch64.AppImage"
    }

    os_type = control.target_os + "-" + ensure_list(control.architecture)[0]

    # Getting latest version information from official sources
    print("API used is: %s" % api_url)
    json_load = wgets(api_url, proxies=proxies, as_json=True)
    for to_download in json_load["assets"]:
        if update_dict[os_type] in to_download["name"]:
            download_url = to_download["browser_download_url"]
            latest_bin = to_download["name"]
            version = json_load["tag_name"].split("-")[-1].replace("v", "")
            latest_bin_extension = latest_bin.rsplit('.', 1)[-1]
            break

    # Downloading latest binaries
    print(f"Latest {app_name} version is: {version}")
    print(f"Download URL is: {download_url}")
    if not isfile(latest_bin):
        print(f"Downloading: {latest_bin}")
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print(f"Binary is present: {latest_bin}")

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print(f"Software version updated (from: {control.get_software_version()} to: {Version(version)})")
        package_updated = True
    else:
        print(f"Software version up-to-date ({Version(version)})")

    for f in glob.glob(f'*.{latest_bin_extension}'):
        if f != latest_bin:
            remove_file(f)

    control.set_software_version(version)
    control.save_control_to_wapt()

    return package_updated
