# -*- coding: utf-8 -*-
from setuphelpers import *

r"""
Usable WAPT package functions: install(), uninstall(), session_setup(), audit(), update_package()
{
   "key":"Conan Package Manager_is1",
   "name":"Conan Package Manager version 1.65.0",
   "version":"1.65.0",
   "install_date":"2024-08-14 00:00:00",
   "install_location":"C:\\Program Files\\Conan\\",
   "uninstall_string":"\"C:\\Program Files\\Conan\\unins000.exe\"",
   "publisher":"",
   "system_component":0,
   "win64":true
  }

"""
# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls


def install():
    # Declaring local variables
    bin_name = glob.glob('conan-*.exe')[0]
    # Installing the software

    install_exe_if_needed(bin_name,
        silentflags='/VERYSILENT /SUPPRESSMSGBOXES /NORESTART',
        key='',
        min_version=control.get_software_version(),
    )

def uninstall():
    killalltasks(ensure_list(control.impacted_process))
    run(r'"C:\Program Files\Conan\unins000.exe" /SILENT')