# -*- coding: utf-8 -*-
from setuphelpers import *
import platform

def install():

    wads_folder = makepath(WAPT.wapt_base_dir, 'waptserver', 'repository', 'wads')

    if platform.system() == 'Linux':
        if type_debian():
            wads_folder = '/var/www/wads'
        elif type_redhat():
            wads_folder = '/var/www/html/wads'

    iniwaptserver =  makepath(WAPT.wapt_base_dir,'conf','waptserver.ini')
    if isfile(iniwaptserver):
        inivalue = inifile_readstring(iniwaptserver,"options","wads_folder")
        if inivalue :
            wads_folder = inivalue

    if isdir(makepath(wads_folder,'pxe')):
        filecopyto("ipxe.efi",makepath(wads_folder,"pxe","ipxe_github.efi"))
        filecopyto("snponly.efi",makepath(wads_folder,"pxe","snponly_github.efi"))
        filecopyto("snponlyarm64.efi",makepath(wads_folder,"pxe","snponlyarm64_github.efi"))
        filecopyto("ipxearm64.efi",makepath(wads_folder,"pxe","ipxearm64_github.efi"))
        filecopyto("undionly.kpxe",makepath(wads_folder,"pxe","undionly_github.kpxe"))
        filecopyto("ipxe.kpxe",makepath(wads_folder,"pxe","ipxe_github.kpxe"))
        if platform.system() == 'Linux':
            if type_debian():
                nginx_user = 'www-data'
            elif type_redhat():
                nginx_user = 'nginx'
            run('chown wapt:%s "%s"' %  (nginx_user,makepath(wads_folder,"pxe","ipxe_github.efi")))
            run('chown wapt:%s "%s"' %  (nginx_user,makepath(wads_folder,"pxe","snponly_github.efi")))
            run('chown wapt:%s "%s"' %  (nginx_user,makepath(wads_folder,"pxe","snponlyarm64_github.efi")))
            run('chown wapt:%s "%s"' %  (nginx_user,makepath(wads_folder,"pxe","ipxearm64_github.efi")))
            run('chown wapt:%s "%s"' %  (nginx_user,makepath(wads_folder,"pxe","undionly_github.kpxe")))
            run('chown wapt:%s "%s"' %  (nginx_user,makepath(wads_folder,"pxe","ipxe_github.kpxe")))
    else:
        print('SKIP Folder %s not exist' % makepath(wads_folder,'pxe'))




