# -*- coding: utf-8 -*-
from setuphelpers import *
import glob

r"""
https://www.citrix.com/support/product-lifecycle/workspace-app
https://docs.citrix.com/citrix-workspace-app-for-windows/install
https://docs.citrix.com/citrix-workspace-app-for-windows/deploy

wapt-get list-registry "Citrix Systems, Inc." --json
{
 "output":[],
 "config_filename":"C:\\Program Files (x86)\\wapt\\wapt-get.ini",
 "result":[
  {
   "key":"CitrixOnlinePluginPackWeb",
   "name":"Citrix Workspace 2309",
   "version":"23.9.1.104",
   "install_date":"2023-12-20 00:00:00",
   "install_location":"C:\\PROGRAM FILES (X86)\\CITRIX\\",
   "uninstall_string":"\"C:\\Program Files (x86)\\Citrix\\Citrix WorkSpace 2309\\TrolleyExpress.exe\" /uninstall /cleanup",
   "publisher":"Citrix Systems, Inc.",
   "system_component":0,
   "win64":false
  },
  {
   "key":"{203DA246-3E47-4EBA-9580-1887BA483296}",
   "name":"Citrix Workspace (USB)",
   "version":"23.9.1.5",
   "install_date":"2023-12-20 00:00:00",
   "install_location":"C:\\Program Files (x86)\\Citrix\\ICA Client\\",
   "uninstall_string":"MsiExec.exe /I{203DA246-3E47-4EBA-9580-1887BA483296}",
   "publisher":"Citrix Systems, Inc.",
   "system_component":0,
   "win64":false
  },
  {
   "key":"{4812EDA3-548C-41F8-A3E6-DD1D8C06133F}",
   "name":"BCR Plug-in",
   "version":"23.9.1.5",
   "install_date":"2023-12-20 00:00:00",
   "install_location":"",
   "uninstall_string":"MsiExec.exe /I{4812EDA3-548C-41F8-A3E6-DD1D8C06133F}",
   "publisher":"Citrix Systems, Inc.",
   "system_component":0,
   "win64":false
  },
  {
   "key":"{540A2BE7-17F0-4C14-A34E-9688225D88E2}",
   "name":"Citrix Authentication Manager",
   "version":"23.8.0.5",
   "install_date":"2023-12-20 00:00:00",
   "install_location":"",
   "uninstall_string":"MsiExec.exe /X{540A2BE7-17F0-4C14-A34E-9688225D88E2}",
   "publisher":"Citrix Systems, Inc.",
   "system_component":0,
   "win64":false
  },
  {
   "key":"{5E1F37CE-F8A1-4617-B330-99979197B105}",
   "name":"Online Plug-in",
   "version":"23.9.1.5",
   "install_date":"2023-12-20 00:00:00",
   "install_location":"",
   "uninstall_string":"MsiExec.exe /I{5E1F37CE-F8A1-4617-B330-99979197B105}",
   "publisher":"Citrix Systems, Inc.",
   "system_component":0,
   "win64":false
  },
  {
   "key":"{5E538771-35FA-44E5-90DE-70C9233F1EA4}",
   "name":"Citrix Workspace (DV)",
   "version":"23.9.1.5",
   "install_date":"2023-12-20 00:00:00",
   "install_location":"C:\\Program Files (x86)\\Citrix\\ICA Client\\",
   "uninstall_string":"MsiExec.exe /X{5E538771-35FA-44E5-90DE-70C9233F1EA4}",
   "publisher":"Citrix Systems, Inc.",
   "system_component":0,
   "win64":false
  },
  {
   "key":"{72B2AE1F-4FAC-44C4-925A-C243D7B2C453}",
   "name":"MTOP Client",
   "version":"23.9.1.5",
   "install_date":"2023-12-20 00:00:00",
   "install_location":"",
   "uninstall_string":"MsiExec.exe /I{72B2AE1F-4FAC-44C4-925A-C243D7B2C453}",
   "publisher":"Citrix Systems, Inc.",
   "system_component":0,
   "win64":false
  },
  {
   "key":"{937F4ADF-7AC6-428B-B2D1-683CD14A56EB}",
   "name":"Citrix Workspace Inside",
   "version":"23.9.1.63",
   "install_date":"2023-12-20 00:00:00",
   "install_location":"",
   "uninstall_string":"MsiExec.exe /I{937F4ADF-7AC6-428B-B2D1-683CD14A56EB}",
   "publisher":"Citrix Systems, Inc.",
   "system_component":0,
   "win64":false
  },
  {
   "key":"{AC8A4EA8-6C72-4052-A3E5-17BA44FC1D9A}",
   "name":"Citrix Web Helper",
   "version":"23.9.1.41",
   "install_date":"2023-12-20 00:00:00",
   "install_location":"",
   "uninstall_string":"MsiExec.exe /X{AC8A4EA8-6C72-4052-A3E5-17BA44FC1D9A}",
   "publisher":"Citrix Systems, Inc.",
   "system_component":0,
   "win64":false
  },
  {
   "key":"{C3ADC2D9-491E-436E-83FC-CDE9486E28EF}",
   "name":"AppProtection",
   "version":"23.8.0.13",
   "install_date":"2023-12-20 00:00:00",
   "install_location":"",
   "uninstall_string":"",
   "publisher":"Citrix Systems, Inc.",
   "system_component":0,
   "win64":false
  },
  {
   "key":"{E4DC6F03-22CD-4020-9FFA-D68360844195}",
   "name":"Self-Service Plug-in",
   "version":"23.9.1.41",
   "install_date":"2023-12-20 00:00:00",
   "install_location":"",
   "uninstall_string":"MsiExec.exe /X{E4DC6F03-22CD-4020-9FFA-D68360844195}",
   "publisher":"Citrix Systems, Inc.",
   "system_component":0,
   "win64":false
  }
 ]
}

"""
app_soft_names_startwith_list = [
    "Citrix Workspace ",
    "BCR Plug-in",
    "Citrix Authentication Manager",
    "Online Plug-in",
    "MTOP Client",
    "Citrix Web Helper",
    "AppProtection",
    "Self-Service Plug-in",
]


def install():
    bin_name = glob.glob("CitrixWorkspaceApp*.exe")[0]
    silentflags = "AutoUpdateCheck=disabled EnableCEIP=False /silent /noreboot SELFSERVICEMODE=False ENABLEPRELAUNCH=False"

    # Uninstalling older major versions of the software that can remains
    for to_uninstall in installed_softwares("Citrix Systems, Inc."):
        if Version(to_uninstall["version"], 1) < Version(control.get_software_version(), 1):
            if [s for s in app_soft_names_startwith_list if to_uninstall["name"].startswith(s)]:
                if not uninstall_key_exists(to_uninstall["key"]):
                    continue
                print("Removing: %s (%s)" % (to_uninstall["name"], to_uninstall["version"]))
                killalltasks(ensure_list(control.impacted_process))
                run(uninstall_cmd(to_uninstall["key"]))
                wait_uninstallkey_absent(to_uninstall["key"])

    # Installing the software
    if force:
        silentflags += " /CleanInstall"  # forceinstall
    install_exe_if_needed(
        bin_name,
        silentflags=silentflags,
        key="CitrixOnlinePluginPackWeb",
        min_version=control.get_software_version(),
        timeout=900,
    )

    # Adding QuietUninstallString for app
    register_uninstall(
        "CitrixOnlinePluginPackWeb",
        quiet_uninstall_string=installed_softwares(uninstallkey="CitrixOnlinePluginPackWeb")[0]["uninstall_string"] + " /silent /noreboot",
    )

    # Changing default start mode of the application updater service
    set_service_start_mode("CWAUpdaterService", "Disabled")  # Citrix Workspace Advanced Service


def uninstall():
    # Windows 11 remaining key
    # {dcdaa2fd-eaac-4ab0-9ece-f3df127a6c45}.sdb     Citrix Workspace     %windir%\system32\sdbinst.exe -u "C:\Windows\AppPatch\CustomSDB\{dcdaa2fd-eaac-4ab0-9ece-f3df127a6c45}.sdb"
    for to_uninstall in installed_softwares(uninstallkey="{dcdaa2fd-eaac-4ab0-9ece-f3df127a6c45}.sdb"):
        print("Removing: %s (%s)" % (to_uninstall["name"], to_uninstall["version"]))
        killalltasks(control.get_impacted_process_list())
        app_uninstall_cmd = r'"%s" -u "C:\Windows\AppPatch\CustomSDB\{dcdaa2fd-eaac-4ab0-9ece-f3df127a6c45}.sdb"' % makepath(
            os.environ["SYSTEMROOT"], "system32", "sdbinst.exe"
        )
        run(app_uninstall_cmd, accept_returncodes=[0, 3010])
        wait_uninstallkey_absent(to_uninstall["key"], raise_on_timeout=True)
