# -*- coding: utf-8 -*-
from setuphelpers import *
import json


def update_package():
    # Initializing variables
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()

    url_dl_yum = "https://dl.google.com/linux/direct/google-chrome-stable_current_x86_64.rpm"
    latest_bin_yum = url_dl_yum.split("/")[-1]

    # Downloading latest binaries
    print("Download url for RedHat is: " + url_dl_yum)
    if isfile(latest_bin_yum):
        remove_file(latest_bin_yum)

    print("Downloading: " + latest_bin_yum)
    wget(url_dl_yum, latest_bin_yum, proxies=proxies)

    # Getting version from file
    version = run(f"rpm -qp --info {latest_bin_yum}").split("Version")[1].split("\n")[0].split(":")[1].strip()

    # Changing version of the package
    if control.get_software_version() != version:
        print("Changing package version to: %s in WAPT\\control" % control.version)
    else:
        print("Keeping package version to: %s in WAPT\\control" % control.version)
    control.version = "%s-%s" % (version, control.version.split("-", 1)[-1])
    control.save_control_to_wapt()

