# -*- coding: utf-8 -*-
from setuphelpers import *
import json


def update_package():
    # Initializing variables
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()

    url_dl_deb = "https://dl.google.com/linux/direct/google-chrome-stable_current_amd64.deb"
    latest_bin_deb = url_dl_deb.split("/")[-1]

    # Downloading latest binaries
    print("Download url for Debian is: " + url_dl_deb)
    if isfile(latest_bin_deb):
        remove_file(latest_bin_deb)

    print("Downloading: " + latest_bin_deb)
    wget(url_dl_deb, latest_bin_deb, proxies=proxies)

    # Getting version from binary
    version = run(f"dpkg --info {latest_bin_deb}").split("Version: ")[1].split('\n')[0].split("-")[0]

    # Changing version of the package
    if control.get_software_version() != version:
        print("Changing package version to: %s in WAPT\\control" % control.version)
    else:
        print("Keeping package version to: %s in WAPT\\control" % control.version)
    control.version = "%s-%s" % (version, control.version.split("-", 1)[-1])
    control.save_control_to_wapt()