from setuphelpers import *
import waptlicences
import requests

def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()

    update_dict = {"windows": ".dmg"}
    download_url = "https://www.canva.com/download/mac/universal/canva-desktop"

    version_url = requests.head('https://www.canva.com/download/mac/universal/canva-desktop', headers = {'user_agent' : 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36'}, allow_redirects = True).url

    version = version_url.split("/")[-1].split("-")[1]

    latest_bin = f"Canva-{version}-universal.dmg"

    # Downloading latest binaries
    print(f"Latest version of {control.name} is: {version}")
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        # print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print("Binary is present: %s" % latest_bin)


    # Downloading latest binaries
    print(f"Latest version of {control.name} is: {version}")
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print("Binary is present: %s" % latest_bin)



    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print(f"Software version updated (from: {control.get_software_version()} to: {Version(version)})")
        package_updated = True
    else:
        print(f"Software version up-to-date ({Version(version)})")

    # Deleting binaries
    for f in glob.glob("*.dmg"):
        if f != latest_bin:
            remove_file(f)
    
    control.set_software_version(version)
    control.save_control_to_wapt()

    return package_updated
