# -*- coding: utf-8 -*-
from setuphelpers import *

def update_package():
    # Declaring local variables
    result = False
    proxies = get_proxies_from_wapt_console()
    if not proxies:
        proxies = get_proxies()

    # Si la version est en dessous la version min_os_version : 10.0.18362 alors =>
    if windows_version() >= Version("10.0.18362"):
        for to_uninstall in installed_softwares(name="CamStudio"):
            print(f"Removing: {to_uninstall['name']} ({to_uninstall['version']})")
            killalltasks(ensure_list(control.impacted_process))
            run(uninstall_cmd(to_uninstall["key"]), timeout=1200)
            wait_uninstallkey_absent(to_uninstall["key"])

        datasite = wgets('https://camstudio.org', proxies=proxies)
        download_url = 'https://' + datasite.split('.exe')[0].split('https://')[-1] + '.exe'
        print(download_url)

        datasite = wgets('https://camstudio.org/changelog.php', proxies=proxies)
        version = datasite.split('Version ')[1].split(' ')[0]
        print(f"Version: {version}")
        latest_bin = "CamStudioSetup.exe"

        if (not isfile(latest_bin)) or (Version(version) > control.get_software_version()):
            print(f"Downloading: {latest_bin}")
            wget(download_url, latest_bin, proxies=proxies)
            result = True