# -*- coding: utf-8 -*-
from setuphelpers import *

exe_name = 'CamStudioSetup.exe'
path_app = makepath(programfiles,'CamStudio')
path_exe = makepath(path_app,exe_name)
nameshortcut = 'CamStudio'

# INSTALLATION PACKAGE
def install():
    for to_uninstall in installed_softwares(name="CamStudio"):
        print(f"Removing: {to_uninstall['name']} ({to_uninstall['version']})")
        killalltasks(ensure_list(control.impacted_process))
        run(uninstall_cmd(to_uninstall["key"]))
        wait_uninstallkey_absent(to_uninstall["key"])

    mkdirs(path_app)
    filecopyto(exe_name,path_exe)
    create_desktop_shortcut(nameshortcut,path_exe)
    create_programs_menu_shortcut(nameshortcut,path_exe)

# AUDIT DE L'APPLICATIF
def audit():
    if not isfile(path_exe):
        print('File not found')
        return "ERROR"
    else:
        print('File Found')
        return "OK"

# DESINSTALLER PACKAGE PORTABLE
def uninstall():
    killalltasks(ensure_list(control.impacted_process))
    time.sleep(5)
    if isdir(path_app):
        remove_tree(path_app)
    remove_desktop_shortcut(nameshortcut)
    remove_programs_menu_shortcut(nameshortcut)