# -*- coding: utf-8 -*-
from setuphelpers import *

"""
Usable WAPT package functions: install(), uninstall(), session_setup(), audit(), update_package()

https://calibre-ebook.com/download_linux

"""
# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls
bin_contains = "calibre"


def install():
    # Declaring local variables
    bin_name = glob.glob("*%s*.txz" % bin_contains)[0]

    install_apt('gettext libgl1-mesa-dev libxkbcommon-dev libxkbcommon-x11-dev libfontconfig1 libxcb-cursor-dev')
    # Installing the package
    run("mkdir -p /opt/calibre && rm -rf /opt/calibre/* && tar xvf %s -C /opt/calibre && /opt/calibre/calibre_postinstall" % bin_name)


def uninstall():
    # Uninstalling the package
    remove_tree('/opt/calibre')
