# -*- coding: utf-8 -*-
from setuphelpers import *
import json


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name
    api_url = "https://api.github.com/repos/bitwarden/clients/releases"
    dict_arch_name = {"x64": "x64", "x86": "ia32"}

    # Getting latest version information from official sources
    print("API used is: %s" % api_url)
    dict_result = json.loads(wgets(api_url, proxies=proxies))
    for tag in dict_result:
        if tag["name"].startswith("Desktop ") and not tag["draft"] and not tag["prerelease"]:
            print("Tag URL used is: %s" % tag["html_url"])
            version = tag["tag_name"].split("-")[-1].replace("v", "")
            for download in tag["assets"]:
                if "Bitwarden-Installer-" in download["name"]:
                    download_url = download["browser_download_url"]
                    latest_bin = download["name"]
                if "-%s.nsis.7z" % dict_arch_name[control.architecture] in download["name"]:
                    latest_bin_7z = download["name"]
                    download_url_7z = download["browser_download_url"]
            break

    # Downloading latest binaries
    print("Latest %s version is: %s" % (app_name, version))
    print("Download URL 1 is: %s" % download_url)
    print("Download URL 2 is: %s" % download_url_7z)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print("Binary is present: %s" % latest_bin)
    if not isfile(latest_bin_7z):
        print("Downloading: %s" % latest_bin_7z)
        wget(download_url_7z, latest_bin_7z, proxies=proxies)
    else:
        print("Binary is present: %s" % latest_bin_7z)

    # Checking version from file
    version_from_file = get_version_from_binary(latest_bin).split("-")[0]
    # if not version_from_file.startswith(version) and version_from_file != '':
    if Version(version_from_file) != Version(version) and version_from_file != "":
        print("Changing version to the version number of the binary")
        os.rename(latest_bin, latest_bin.replace(version, version_from_file))
        version = version_from_file
    else:
        print("Binary file version corresponds to online version")

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        package_updated = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.set_software_version(version)
    control.save_control_to_wapt()

    # Deleting outdated binaries
    remove_outdated_binaries(version, list_extensions=["exe", "msi", "7z"])

    # Validating update-package-sources
    return package_updated
