# -*- coding: utf-8 -*-
from setuphelpers import *
import json


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name
    api_url = "https://api.github.com/repos/bitwarden/clients/releases"

    # Getting latest version information from official sources
    print("API used is: %s" % api_url)
    dict_result = json.loads(wgets(api_url, proxies=proxies))
    for tag in dict_result:
        if tag["name"].startswith("Desktop ") and not tag["draft"] and not tag["prerelease"]:
            print("Tag URL used is: %s" % tag["html_url"])
            version = tag["tag_name"].split("-")[-1].replace("v", "")
            for download in tag["assets"]:
                if download["name"].endswith(".rpm"):
                    download_url = download["browser_download_url"]
                    latest_bin = download["name"]
                    break
            break

    # Downloading latest binaries
    print("Latest %s version is: %s" % (app_name, version))
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print("Binary is present: %s" % latest_bin)

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        package_updated = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.set_software_version(version)
    control.save_control_to_wapt()

    # Deleting outdated binaries
    remove_outdated_binaries(version)

    # Validating update-package-sources
    return package_updated
