# -*- coding: utf-8 -*-
from setuphelpers import *

app_bin = "Bitwarden-Portable.exe"
app_dir = makepath(programfiles32, "Bitwarden")
app_bin_path = makepath(app_dir, app_bin)
processes_to_kill = ["Bitwarden", "Bitwarden-Portable"]


def install():
    # Initializing variables
    package_version = control.version.split("-", 1)[0]
    bin_name = bin_name = glob.glob("Bitwarden-Portable*.exe")[0]

    # Installing the package
    print("Installing: %s" % bin_name)
    if get_version_from_binary(app_bin_path) != package_version:
        killalltasks(processes_to_kill)
        if isdir(app_dir):
            remove_tree(app_dir)
        mkdirs(app_dir)
        print("Copying %s to %s " % (bin_name, app_bin_path))
        filecopyto(bin_name, app_bin_path)
        # remove_programs_menu_shortcut("Bitwarden")

        # Adding this package to the "list-registry"
        register_windows_uninstall(control)  # control is a PackageEntry object corresponding to this package
    else:
        print("%s portable version is already installed in the correct version" % "Bitwarden")


def uninstall():
    # Uninstalling the package
    killalltasks(processes_to_kill)
    if isdir(app_dir):
        remove_tree(app_dir)
        unregister_uninstall("Bitwarden Portable")
    remove_programs_menu_shortcut("Bitwarden")


def session_setup():
    # Initializing variables
    user_app_dir = makepath(application_data, "Bitwarden-Portable")
    user_app_bin_path = makepath(user_app_dir, app_bin)

    # Installing the package in user env
    print("Installing: %s in user env" % "Bitwarden")
    if get_version_from_binary(user_app_bin_path) != installed_softwares("Bitwarden")[0]["version"]:
        killalltasks(processes_to_kill)
        if isdir(user_app_dir):
            remove_tree(user_app_dir)
        mkdirs(user_app_dir)
        print("Copying %s to %s " % (app_bin_path, user_app_bin_path))
        filecopyto(app_bin_path, user_app_bin_path)
        create_user_programs_menu_shortcut("Bitwarden", user_app_bin_path)
    else:
        print("%s portable version in user env is already installed in the correct version" % "Bitwarden")
