# -*- coding: utf-8 -*-
from setuphelpers import *

app_name = "Beekeeper-Studio"
app_dir = makepath(programfiles, app_name)


def install():
    bin_name = glob.glob("Beekeeper-Studio-*-portable.exe")[0]
    app_path = makepath(app_dir, bin_name)

    # Installing software
    killalltasks(ensure_list(control.impacted_process))
    if isdir(app_dir) and force:
        remove_tree(app_dir)
    mkdirs(app_dir)
    filecopyto(bin_name, app_path)

    # Creating shortcuts
    create_programs_menu_shortcut(app_name, target=app_path)


def uninstall():
    # Uninstalling software
    killalltasks(ensure_list(control.impacted_process))
    if isdir(app_dir):
        remove_tree(app_dir)

    # Removing shortcuts
    remove_programs_menu_shortcut(app_name)
