# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *
import re


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()

    api_url = "https://api.github.com/repos/beekeeper-studio/beekeeper-studio/releases/latest"

    update_dict = {
        "windows": ".exe",
    }

    # Get data from API
    releases_dict = json.loads(wgets(api_url, proxies=proxies))
    exe_found = False  # Flag pour indiquer la découverte d'un fichier .exe
    for release in releases_dict:
        if exe_found:
            break
        for asset in releases_dict["assets"]:
            if (
                ("portable") in asset["browser_download_url"]
                and asset["browser_download_url"].endswith(".exe")
                and update_dict[control.target_os] in asset["browser_download_url"]
            ):
                url_download = asset["browser_download_url"]
                latest_bin = url_download.split("/")[-1]
                version = releases_dict["tag_name"].replace("v", "")
                exe_found = True  # Mettre à jour le flag pour indiquer qu'un exe a été trouvé
                break

    if not isfile(latest_bin):
        package_updated = True
        wget(url_download, latest_bin, proxies=proxies)

    # Deleting binaries
    for f in glob.glob("*.exe"):
        if f != latest_bin:
            remove_file(f)

    version = get_version_from_binary(latest_bin)

    control.set_software_version(version)
    control.save_control_to_wapt()

    return package_updated
