# -*- coding: utf-8 -*-
from setuphelpers import *

r"""
Usable WAPT package functions: install(), uninstall(), session_setup(), audit(), update_package()

"""
# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls

bin_test = makepath(programfiles(),'Remote Desktop','msrdc.exe')

def install():
    # Declaring local variables
    bin_name = glob.glob('RemoteDesktop_*_x64.msi')[0]

    # Installing the software
    if Version(get_version_rd()) < Version(control.get_software_version()) or force:
        run(r'"%s" /norestart /q /i "%s"' % (makepath(system32(),'msiexec.exe'), bin_name), accept_returncodes=[0, 3010], timeout=300)
    
    if Version(get_version_rd()) < Version(control.get_software_version()):
        error('"%s" missmatch version : %s != %s' % (bin_test,get_version_rd(),control.get_software_version()))

    #append uninstallkey
    for soft in installed_softwares():
        if soft['install_location'].lower().strip('\\') == makepath(programfiles(),'Remote Desktop').lower():
            uninstallkey.append(soft['key'])

def get_version_rd():
    return get_file_properties(bin_test)['ProductVersion'] if isfile(bin_test) else '0'
