# -*- coding: utf-8 -*-
from setuphelpers import *
import os
import json


def update_package():
    proxies = {}
    if isfile(makepath(user_local_appdata(), "waptconsole", "waptconsole.ini")):
        proxywapt = inifile_readstring(makepath(user_local_appdata(), "waptconsole", "waptconsole.ini"), "global", "http_proxy")
        if proxywapt:
            proxies = {"http": proxywapt, "https": proxywapt}

    currentpath = os.path.dirname(os.path.realpath(__file__))

    url_api = "https://api.github.com/repos/glpi-project/glpi-agent/releases"

    json_load = json.loads(wgets(url_api, proxies=proxies))

    found = False
    for releases in json_load:
        if found:
            break
        for download in releases["assets"]:
            if download["browser_download_url"].endswith("%s.zip" % control.architecture):
                url_dl = download["browser_download_url"]
                binary = url_dl.split("/")[-1]
                found = True
                break


    version = binary.split('-')[2]
    allexe = glob.glob("*.zip")
    for f in allexe:
        if f != binary:
            remove_file(f)

    if not isfile(binary):
        wget(url_dl,binary,proxies=proxies)


    control.version = version + "-0"
    control.save_control_to_wapt()

