# -*- coding: utf-8 -*-
from setuphelpers import *
import json


def install():

    azip = glob.glob("*.zip")[0]
    unzip(azip,makepath(persistent_dir))


def audit():
    jsonfile = makepath(persistent_dir,'inventory.json')
    run('"%s" --json > "%s"' % (makepath(persistent_dir,'glpi-inventory.bat'),jsonfile))
    with open(jsonfile,'rb') as f:
        datajson = json.load(f)

    WAPT.write_audit_data_if_changed("audit-glpi-inventory", "audit-glpi-inventory", datajson, keep_days=365,max_count=1)

    return "OK"
