# -*- coding: utf-8 -*-
from setuphelpers import *
import json


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name
    api_url = "https://api.github.com/repos/audacity/audacity/releases/latest"
    if control.architecture == "x64":
        arch_contains = "-64bit.exe"
        arch_contains2 = "x64.exe"
    else:
        arch_contains = "-32bit.exe"
        arch_contains2 = "x32.exe"

    # Getting latest version information from official sources
    print("API used is: %s" % api_url)
    json_load = json.loads(wgets(api_url, proxies=proxies))
    for download in json_load["assets"]:
        if arch_contains in download["name"] or arch_contains2 in download["name"]:
            download_url = download["browser_download_url"]
            version = json_load["tag_name"].split("-")[-1]
            latest_bin = download["name"]
            break

    # Downloading latest binaries
    print("Latest %s version is: %s" % (app_name, version))
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print("Binary is present: %s" % latest_bin)

    # Checking version from file
    version_from_file = get_file_properties(latest_bin)["FileDescription"].split(" ")[1]
    # if not version_from_file.startswith(version) and version_from_file != '':
    if Version(version_from_file) != Version(version) and version_from_file != "":
        print("Changing version to the version number of the binary")
        os.rename(latest_bin, latest_bin.replace(version, version_from_file))
        version = version_from_file
    else:
        print("Binary file version corresponds to online version")

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        package_updated = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.set_software_version(version)
    control.save_control_to_wapt()

    # Deleting outdated binaries
    remove_outdated_binaries(version)

    # Validating update-package-sources
    return package_updated
