# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *


def update_package():
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()

    dict_arch ={
        "x64" :"x64.exe",
        "x86" :"x86.exe"
    }
    git_repo = "asyncapi/cli"
    url_api = "https://api.github.com/repos/%s/releases/latest" % git_repo

    # Getting latest version information from official sources
    print("API used is: %s" % url_api)
    json_load = wgets(url_api, proxies=proxies, as_json=True)

    for download in json_load["assets"]:
        if download["browser_download_url"].endswith('.exe') and dict_arch[control.architecture] in download["browser_download_url"]:
            download_url = download["browser_download_url"]
            version = json_load["tag_name"].replace("v","")
            latest_bin = download["name"]
            break

    # Downloading latest binaries
    print("Latest %s version is: %s" % (control.name, version))
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print("Binary is present: %s" % latest_bin)

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        package_updated = True
    else:
        print("Software version up-to-date (%s)" % Version(version))

    #nettoyer les fichiers temporaires
    for f in glob.glob('*.exe'):
        if f != latest_bin:
            remove_file(f)

    version = get_version_from_binary(latest_bin)

    control.set_software_version(version)
    control.save_control_to_wapt()

    return package_updated