# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *
import waptlicences


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name

    git_repo = "AppFlowy-IO/AppFlowy"
    api_url = f"https://api.github.com/repos/{git_repo}/releases/latest"

    os_dict = {
        'windows-x64': '-windows-x86_64.exe',
        'darwin-all': '-macos-universal.dmg',
    }

    os_type = control.target_os + "-" + ensure_list(control.architecture)[0]

    releases_dict = wgets(api_url, proxies=proxies, as_json=True)

    for asset in releases_dict["assets"]:
        if asset["name"].endswith(os_dict[os_type]):
            download_url = asset["browser_download_url"]
            latest_bin = asset["name"]
            latest_bin_extension = latest_bin.rsplit('.', 1)[-1]
            version = releases_dict["tag_name"].replace('v', '')
            break

    # Downloading latest binaries
    print(f"Latest {app_name} version is: {version}")
    print(f"Download URL is: {download_url}")
    if not isfile(latest_bin):
        print(f"Downloading: {latest_bin}")
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print(f"Binary is present: {latest_bin}")

    expected_issuer = "APPFLOWY PTE. LTD."
    sign_name = waptlicences.check_msi_signature(latest_bin)[0]
    if sign_name != expected_issuer:
        error(f'Bad issuer {sign_name} != {expected_issuer} ')

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print(f"Software version updated (from: {control.get_software_version()} to: {Version(version)})")
        package_updated = True
    else:
        print(f"Software version up-to-date ({Version(version)})")

    for f in glob.glob(f'*.{latest_bin_extension}'):
        if f != latest_bin:
            remove_file(f)

    control.set_software_version(version)
    control.save_control_to_wapt()

    return package_updated