# -*- coding: utf-8 -*-
from setuphelpers import *

def update_package():
    proxies = get_proxies_from_wapt_console()
    if not proxies:
        proxies = get_proxies()

    latest_bin = "AnyDesk.exe"
    download_url = "https://download.anydesk.com/AnyDesk.exe"

    remove_outdated_binaries("*")

    if not isfile(latest_bin):
        print("Téléchargement", latest_bin)
        wget(download_url, latest_bin, proxies=proxies)

    version = get_file_properties(latest_bin)["FileVersion"]
    print(f"Version: {version}")

    if Version(version) > Version(control.get_software_version()):
        control.set_software_version(version)
        control.save_control_to_wapt()
        print("Package mis à jour")
        return True

    print("Version à jour")
    return False