# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import unzip_with_7zip 
import re


unzipped_dir = "altair_graphql_extracted"


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    update_dict = {"windows": ".exe", "macos": ".dmg"}
    api_url = "https://api.github.com/repos/altair-graphql/altair/releases/latest"

    # Get data from API
    releases_dict = json.loads(wgets(api_url, proxies=proxies))
    exe_found = False  # Flag pour indiquer la découverte d'un fichier .exe
    # version = json_loads["tag_name"].replace("v", "").replace(".windows", "")
    for release in releases_dict:
        if exe_found:
            break
        for asset in releases_dict["assets"]:
            if asset["browser_download_url"].endswith(".exe") and update_dict[control.target_os] in asset["browser_download_url"]:
                url_download = asset["browser_download_url"]
                latest_bin = url_download.split("/")[-1]
                version = releases_dict["name"].replace("v", "")
                exe_found = True  # Mettre à jour le flag pour indiquer qu'un exe a été trouvé
                break

    # Deleting binaries
    for f in glob.glob("*.exe"):
        if f != latest_bin:
            remove_file(f)

    # Downloading latest binaries
    print("Download URL is: %s" % url_download)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(url_download, latest_bin, proxies=proxies)
    else:
        print("Binary is present: %s" % latest_bin)

    # Extracting archive
    if isdir(unzipped_dir):
        remove_tree(unzipped_dir)
    unzip_with_7zip(latest_bin, unzipped_dir)
    app_7z = makepath(unzipped_dir, "$PLUGINSDIR", "app-64.7z")
    unzip_with_7zip(app_7z, "Altair GraphQL")
    remove_tree(unzipped_dir)

    version = get_version_from_binary(latest_bin)

    remove_file(latest_bin)

    control.set_software_version(version)
    control.save_control_to_wapt()
