# -*- coding: utf-8 -*-
from setuphelpers import *

app_name = "Altair GraphQL"
app_dir = makepath(programfiles, app_name)
app_exe = makepath(programfiles, app_name, "Altair GraphQL Client.exe")
app_7z = makepath("Altair GraphQL", "$PLUGINSDIR", "app-64.7z")


def install():
    # Installing software
    killalltasks(ensure_list(control.impacted_process))
    if isdir(app_dir) and force:
        remove_tree(app_dir)
    mkdirs(app_dir)
    copytree2(app_name, app_dir, onreplace=default_overwrite)

    # #Creating shortcuts
    create_programs_menu_shortcut(app_name, target=app_exe)


def uninstall():
    if isdir(app_dir):
        remove_tree(app_dir)
    remove_programs_menu_shortcut("Altair GraphQL")
