# -*- coding: utf-8 -*-
from setuphelpers import *


def install():
    openjdk_version = control.get_software_version().split(".")[0]
    bin_contains = f"OpenJDK{openjdk_version}U"

    bin_name = glob.glob(f"{bin_contains}*.pkg")[0]
    install_pkg(bin_name)


def uninstall():
    bin_type = control.package.rsplit("-", 1)[-1]
    openjdk_version = control.get_software_version().split(".")[0]

    uninstall_pkg(f"net.temurin.{openjdk_version}.{bin_type}")
    remove_tree(f"/Library/Java/JavaVirtualMachines/temurin-{openjdk_version}.{bin_type}")
