# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    # https://api.adoptium.net/q/swagger-ui/#/Assets/searchReleases
    bin_type = control.package.rsplit("-", 1)[-1]
    openjdk_version = control.get_software_version().split(".")[0]
    bin_contains = f"OpenJDK{openjdk_version}U"
    update_dict = {
        "api_url": {
            "windows-x64": f"https://api.adoptium.net/v3/assets/feature_releases/{openjdk_version}/ga?architecture=x64&heap_size=normal&image_type={bin_type}&jvm_impl=hotspot&os=windows",
            "windows-x86": f"https://api.adoptium.net/v3/assets/feature_releases/{openjdk_version}/ga?architecture=x86&heap_size=normal&image_type={bin_type}&jvm_impl=hotspot&os=windows",
            "mac-x64": f"https://api.adoptium.net/v3/assets/feature_releases/{openjdk_version}/ga?architecture=x64&heap_size=normal&image_type={bin_type}&jvm_impl=hotspot&os=mac",
            "mac-aarch64": f"https://api.adoptium.net/v3/assets/feature_releases/{openjdk_version}/ga?architecture=aarch64&heap_size=normal&image_type={bin_type}&jvm_impl=hotspot&os=mac",
            "linux-x64": f"https://api.adoptium.net/v3/assets/feature_releases/{openjdk_version}/ga?architecture=x64&heap_size=normal&image_type={bin_type}&jvm_impl=hotspot&os=linux",
            "linux-aarch64": f"https://api.adoptium.net/v3/assets/feature_releases/{openjdk_version}/ga?architecture=aarch64&heap_size=normal&image_type={bin_type}&jvm_impl=hotspot&os=linux",
        }
    }
    api_url = update_dict["api_url"][f'{ensure_list(control.target_os)[0].split("(")[0]}-{ensure_list(control.architecture)[0]}']

    # Getting latest version information from official API
    print("API used is: %s" % api_url)
    json_load = wgets(api_url, proxies=proxies, as_json=True)
    for to_download in json_load:
        version = to_download["version_data"]["semver"].replace("+", ".")
        download_url = to_download["binaries"][0]["installer"]["link"]
        latest_bin = to_download["binaries"][0]["installer"]["name"]
        break

    # Downloading latest binaries
    print("Latest %s version is: %s" % (control.name, version))
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print("Binary is present: %s" % latest_bin)

    # Downloading windows-x86 binary for windows-x64
    if f'{ensure_list(control.target_os)[0].split("(")[0]}-{ensure_list(control.architecture)[0]}' == "windows-x64":
        api_url = update_dict["api_url"][f"windows-x86"]

        # Getting latest version information from official API
        print("API used is: %s" % api_url)
        json_load = wgets(api_url, proxies=proxies, as_json=True)
        for to_download in json_load:
            version = to_download["version_data"]["semver"].replace("+", ".")
            download_url = to_download["binaries"][0]["installer"]["link"]
            latest_bin = to_download["binaries"][0]["installer"]["name"]
            break

        # Downloading latest binaries
        print("Latest %s version is: %s" % (control.name, version))
        print("Download URL is: %s" % download_url)
        if not isfile(latest_bin):
            print("Downloading: %s" % latest_bin)
            wget(download_url, latest_bin, proxies=proxies)
        else:
            print("Binary is present: %s" % latest_bin)

        # Deleting outdated binaries
        remove_outdated_binaries(version)

    else:
        # Deleting outdated binaries
        remove_outdated_binaries(latest_bin)

    # Checking version from file
    if get_os_name() == "Windows" and "windows" in control.target_os.lower():
        version_from_file = get_version_from_binary(latest_bin)
        if Version(version_from_file, 4) == Version(version, 4):
            print(f"INFO: Binary file version ({version_from_file}) corresponds to online version ({version})")
        else:
            error(f"ERROR: Binary file version ({version_from_file}) do NOT corresponds to online version ({version})")

    # Changing version of the package
    if Version(version, 4) > Version(control.get_software_version(), 4):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        package_updated = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.set_software_version(version)
    control.save_control_to_wapt()

    # Validating update-package-sources
    return package_updated

    # # Changing version of the package and validating update-package-sources
    # return complete_control_version(control, version)
