# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *


def install():

    install_location_wapt_get = installed_softwares('WAPT_is1')[0]['install_location']
    bin_name_path_wapt_get = makepath(install_location_wapt_get, 'wapt-get.exe')

    print("Adding WAPT IDE to the right click menu")

    registry_set(HKEY_CLASSES_ROOT, r'Directory\Background\shell\WAPT IDE', '', 'Edit with WAPT', REG_EXPAND_SZ)
    registry_set(HKEY_CLASSES_ROOT, r'Directory\Background\shell\WAPT IDE', 'Icon', f'"{bin_name_path_wapt_get}"', REG_EXPAND_SZ)
    registry_set(HKEY_CLASSES_ROOT, r'Directory\Background\shell\WAPT IDE\command', '', f'wapt-get edit "%V"', REG_EXPAND_SZ)

    registry_set(HKEY_CLASSES_ROOT, r'Directory\shell\WAPT IDE', '', 'Edit with WAPT', REG_EXPAND_SZ)
    registry_set(HKEY_CLASSES_ROOT, r'Directory\shell\WAPT IDE', 'Icon', f'"{bin_name_path_wapt_get}"', REG_EXPAND_SZ)
    registry_set(HKEY_CLASSES_ROOT, r'Directory\shell\WAPT IDE\command', '', f'wapt-get edit "%V"', REG_EXPAND_SZ)


def uninstall():

    print("Removing WAPT IDE to the right click menu")

    vscode_registry_entries = [
        (HKEY_CLASSES_ROOT, r'Directory\Background\shell', 'WAPT IDE'),
        (HKEY_CLASSES_ROOT, r'Directory\shell', 'WAPT IDE')
    ]

    for root_key, subkey_path, key_name in vscode_registry_entries:
        full_path = f"{subkey_path}\\{key_name}"
        if reg_key_exists(root_key, full_path):
            registry_deletekey(root_key, subkey_path, key_name, recursive=True)