# -*- coding: utf-8 -*-
from setuphelpers import *

r"""
Usable WAPT package functions: install(), uninstall(), session_setup(), audit(), update_package()

"""
# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls

app_name = "ABDownloadManager"
app_dir = makepath(programfiles, app_name)
app_path = makepath(app_dir, f"{app_name}.exe")

def install():
    # Declaring local variables
    zip_name = glob.glob('ABDownloadManager_*_windows_x64.zip')[0]

    uninstall_older_version()
    
    unzip(zip_name, makepath(programfiles))
    create_programs_menu_shortcut(app_name, app_path)

def uninstall():
    #Uninstalling software
    killalltasks(ensure_list(control.impacted_process))
    if isdir(app_dir):
        remove_tree(app_dir)
    
    remove_programs_menu_shortcut(app_name)


def uninstall_older_version():

    killalltasks(ensure_list(control.impacted_process))

    for soft in installed_softwares(control.name):
        unistall_key = soft['key']
        if Version(soft['version']) < Version(control.get_software_version()):
            run(uninstall_cmd(unistall_key))
            wait_uninstallkey_absent(unistall_key)




