# -*- coding: utf-8 -*-
from setuphelpers import *
import tarfile

bin_path = makepath("/", "usr", "local", "bin")


def install():
    # unzipping bin to /usr/bin
    bin_name = glob.glob("7z*.tar.xz")[0]
    
    with tarfile.open(bin_name, "r:xz") as tar:
        tar.extractall()

    print(f"copying 7zz to {bin_path}")
    filecopyto("7zz", bin_path)
    if not isfile(f"{bin_path}/7z"):
        print("create 7z alias in path")
        os.symlink(f"{bin_path}/7zz", f"{bin_path}/7z")


def uninstall():
    if isfile(f"{bin_path}/7zz"):
        remove_file(f"{bin_path}/7zz")
    if isfile(f"{bin_path}/7z"):
        os.unlink(f"{bin_path}/7z")
