# -*- coding: utf-8 -*-
from setuphelpers import *
import requests


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    url = "https://www.7-zip.org/download.html"
    download_dict = {
        "windows-x64": "https://www.7-zip.org/a/7znodotversion-x64.exe",
        "windows-arm64": "https://www.7-zip.org/a/7znodotversion-arm64.exe",
        "windows-x86": "https://www.7-zip.org/a/7znodotversion.exe",
        "linux-x64": "https://www.7-zip.org/a/7znodotversion-linux-x64.tar.xz",
        "linux-arm64": "https://www.7-zip.org/a/7znodotversion-linux-arm64.tar.xz",
        "darwin-all": "https://www.7-zip.org/a/7znodotversion-mac.tar.xz",
    }

    # Getting latest version from official sources
    print("URL used is: %s" % url)
    for bs_search in bs_find_all(url, "b", proxies=proxies):
        if "Download 7-Zip " in bs_search.text and not "beta" in bs_search.text:
            version = bs_search.text.split("Zip ")[-1].split(" (")[0]
            nodotversion = version.replace(".", "")
            download_url = download_dict[control.target_os + "-" + control.architecture].replace("nodotversion", nodotversion)
            latest_bin = download_url.split("/")[-1]
            if requests.head(download_url, proxies=proxies, allow_redirects=True).status_code == 200:
                break

    # Downloading latest binaries
    print("Latest %s version is: %s" % (control.name, version))
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print("Binary is present: %s" % latest_bin)

    # Changing version of the package
    if Version(version, 4) > Version(control.get_software_version(), 4):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        package_updated = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.set_software_version(version)
    control.save_control_to_wapt()

    # Deleting outdated binaries
    remove_outdated_binaries(latest_bin)

    # Validating or not update-package-sources
    return package_updated
