# -*- coding: utf-8 -*-
from setuphelpers import *
import tarfile

bin_path = makepath("/", "usr", "local", "bin")


def install():
    # Initializing variables
    bin_name = glob.glob("*7z*.tar.xz")[0]

    # unzipping bin to /usr/bin
    with tarfile.open(bin_name, "r:xz") as tar:
        tar.extractall()
        
    print(f"copying 7zz to {bin_path}")
    filecopyto("7zz", bin_path)
    print("create a symlink 7z for compatibility purpose for p7zip users")
    if isfile(f"{bin_path}/7z"):
        remove_file(f"{bin_path}/7z")
    os.symlink(f"{bin_path}/7zz", f"{bin_path}/7z")


def uninstall():
    print(f"removing 7zz from {bin_path}")
    if isfile(f"{bin_path}/7zz"):
        remove_file(f"{bin_path}/7zz")
    if isfile(f"{bin_path}/7z"):
        remove_file(f"{bin_path}/7z")
