# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *

import json


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()

    for bs_search in reversed(bs_find_all('https://apps.0install.net/0install/0install-win.xml','implementation', proxies=proxies)):
        if 'stable' in str(bs_search):
            version = bs_search['version']
            break

    download_url = f'https://github.com/0install/0install-win/releases/download/{version}/0install.exe'
    latest_bin = '0install.exe'

    # Deleting binaries
    for f in glob.glob("*.exe"):
        print("Removing: %s" % f)
        remove_file(f)

    # Downloading latest binaries
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
        package_updated = True
    else:
        print("Binary is present: %s" % latest_bin)

    print("Downloading content for offline install")
    run(f".{os.sep}{latest_bin} --prepare-offline")

    # Checking version from file
    version = get_version_from_binary(latest_bin)

    control.set_software_version(version.split('+')[0])
    control.save_control_to_wapt()

    # Deleting outdated binaries
    remove_outdated_binaries(latest_bin)

    # Validating update-package-sources
    return package_updated
